<?php

namespace App\Http\Controllers;

use App\Models\GradeFee;
use App\Models\TransportationFee;
use Illuminate\Http\Request;

class FeeController extends Controller
{
    public function index()
    {
        $grade_fees = GradeFee::all();
        $transport_fees = TransportationFee::all();

        return view('fees.index', compact('grade_fees', 'transport_fees'));
    }

    public function create()
{

    $registration_fee = 0;

if ($student) {
    $registration_fee = GradeFee::where('grade', $student->grade)
                                ->where('item', 'registration')
                                ->value('amount_usd') ?? 0;
}
 
    // الصفوف الثابتة
    $grades = [
        'KG1', 'KG2',
        'Grade 1', 'Grade 2', 'Grade 3',
        'Grade 4', 'Grade 5', 'Grade 6',
        'Grade 7', 'Grade 8', 'Grade 9',
        'Grade 10', 'Grade 11', 'Grade 12',
        'IGCSE'
    ];

    // المناطق للمواصلات
    $zones = ['Zone 1', 'Zone 2', 'Zone 3', 'Zone 4'];

    return view('fees.create', compact('grades', 'zones'));
}




    public function storeGrade(Request $request)
    {
        $request->validate([
            'grade' => 'required|string',
            'amount_usd' => 'required|numeric',
            'registration_usd' => 'required|numeric',
        ]);

        GradeFee::create($request->only('grade', 'amount_usd', 'registration_usd'));

        return back()->with('success', 'تم حفظ رسوم الصف بنجاح');
    }

    public function storeTransport(Request $request)
    {
        $request->validate([
            'zone' => 'required|string',
            'fee_egp' => 'required|numeric',
        ]);

        TransportationFee::create($request->only('zone', 'fee_egp'));

        return back()->with('success', 'تم حفظ رسوم المواصلات بنجاح');
    }
}
