<?php

namespace App\Http\Controllers;

use App\Models\Invoice;
use App\Models\Student;
use App\Models\GradeFee;
use App\Models\TransportationFee;
use Illuminate\Http\Request;

class InvoiceController extends Controller
{
    public function create(Request $request)
{
    $students = Student::all();
    $student = null;
    $fees = collect();
    $hasInvoice = false;

    $registration_fee = 0;   // <— INITIAL DEFAULT

    $transportation = TransportationFee::all();

    if ($request->has('student_id')) {
        $student = Student::find($request->student_id);

        if ($student) {
            // Fetch all grade fees
            $fees = GradeFee::where('grade', $student->grade)->get();

            // Fetch dynamic registration fee
            $gradeFee = GradeFee::where('grade', $student->grade)->first();

            $grade_fee = $gradeFee->amount_usd ?? 0;
            $registration_fee = $gradeFee->registration_usd ?? 0;


            // Check invoice existence
            $hasInvoice = Invoice::where('student_id', $student->id)->exists();
        }
    }

    return view('invoices.create', compact(
        'students', 'student', 'fees', 'hasInvoice', 'transportation', 'registration_fee'
    ));
}


    public function store(Request $request)
{
    // Prevent duplicate invoice
    if (Invoice::where('student_id', $request->student_id)->exists()) {
        return redirect()->back()->with('error', 'لا يمكن إنشاء فاتورة أخرى لهذا الطالب.');
    }

    $invoice = Invoice::create([
        'student_id'        => $request->student_id,
        'total_amount'            => $request->total_after_discount,
        'remaining_amount'  => $request->total_after_discount, // Start with full amount as remaining
        'discount_amount'          => $request->discount,
        'fee_egp'         => $request->transport_fee,
        'paid_amount'       => 0,
        'status'            => 'pending', // Add status field
    ]);

    return redirect()->route('invoices.index')->with('success', 'تم إنشاء الفاتورة بنجاح');
}

    public function show(Invoice $invoice)
    {
        return view('invoices.show', compact('invoice'));
    }

    public function index(Request $request)
{
    $query = Invoice::with('student');

    // Search by invoice number or student name
    if ($request->search) {
        $query->where('invoice_no', 'like', "%{$request->search}%")
              ->orWhereHas('student', function ($student) use ($request) {
                  $student->where('full_name', 'like', "%{$request->search}%");
              });
    }

    // Filter by status
    if ($request->status) {
        $query->where('status', $request->status);
    }

    // Filter date range
    if ($request->from_date) {
        $query->whereDate('created_at', '>=', $request->from_date);
    }

    if ($request->to_date) {
        $query->whereDate('created_at', '<=', $request->to_date);
    }

    $invoices = $query->latest()->paginate(12);

    return view('invoices.index', compact('invoices'));
}


    public function updateRemainingAmount()
    {
        $this->paid_amount = $this->payments()->sum('amount_usd');
        $this->remaining_amount = $this->total_amount - $this->paid_amount;
        $this->status = $this->remaining_amount <= 0 ? 'paid' : 
                       ($this->paid_amount > 0 ? 'partial' : 'pending');
        $this->save();
    }

    // Relationship with Student
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    // Relationship with Payments
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }


    public function destroy(Invoice $Invoice)
    {
        $Invoice->delete();
        return redirect()->route('invoices.index')->with('success','تم حذف الفاتورة بنجاح');
    }
}
