<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RoleMiddleware
{
    public function handle(Request $request, Closure $next, $roles)
{
    if (! $request->user()) {
        abort(403, 'غير مصرح بالدخول');
    }

    $rolesArray = explode('|', $roles);

    // Admin bypass
    if ($request->user()->role === 'admin') {
        return $next($request);
    }

    if (! in_array($request->user()->role, $rolesArray)) {
        abort(403, 'غير مصرح بالدخول');
    }

    return $next($request);
}


}
