<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fee extends Model
{
    use HasFactory;

    protected $fillable = [
    'item',
    'item_name',
    'registration_fee',
    'amount',
    'trasboard_zone_1',
    'trasboard_zone_2',
    'trasboard_zone_3',
];


    // Automatically calculate EGP when saving
    public static function booted()
    {
        static::saving(function ($fee) {
            if ($fee->amount_usd && $fee->exchange_rate) {
                $fee->amount_egp = $fee->amount_usd * $fee->exchange_rate;
            }
        });
    }
}
