<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id', 'amount', 'total_amount', 'remaining_amount',
        'discount', 'transport', 'paid_amount', 'status'
    ];

    // Relationship with Student
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    // Relationship with Payments
    public function payments()
    {
        return $this->hasMany(Payment::class);
    }

    // Calculate remaining amount
    public function updateRemainingAmount()
    {
        $this->paid_amount = $this->payments()->sum('amount_usd');
        $this->remaining_amount = $this->total_amount - $this->paid_amount;
        $this->status = $this->remaining_amount <= 0 ? 'paid' : 
                       ($this->paid_amount > 0 ? 'partial' : 'pending');
        $this->save();
    }
}