<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    use HasFactory;

        protected $fillable = [
        'invoice_id',
        'student_id',
        'payment_date',
        'currency',
        'exchange_rate',
        'amount',
        'amount_usd',
        'method',
        'notes',
    ];



    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function installment()
    {
        return $this->belongsTo(Installment::class);
    }

    public function student()
    {
        return $this->hasOneThrough(Student::class, Invoice::class, 'id', 'id', 'invoice_id', 'student_id');
    }
}
