<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory;

    protected $fillable = [
        'serial_number', 'fname', 'middle_name', 'lname', 'date_of_birth', 'birth_city',
        'birth_country','nationality','gender','address','blood_type','photo',
        'parent_full_name','marital_status','telephone','whatsapp','email','education','job',
        'grade','academic_year','has_allergies','allergies_details','has_medical_conditions','medical_condition_details'
    ];

    public function invoices()
    {
        return $this->hasMany(Invoice::class);
    }

    public function installments()
    {
        return $this->hasMany(Installment::class);
    }

    public function payments()
    {
        return $this->hasManyThrough(Payment::class, Invoice::class);
    }

    // in App\Models\Student.php
public function grade()
{
    return $this->belongsTo(Grade::class, 'grade_id');
}

}
