<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('serial_number')->unique();
            // Section A: Personal
            $table->string('fname');
            $table->string('middle_name')->nullable();
            $table->string('lname');
            $table->date('date_of_birth')->nullable();
            $table->string('birth_city')->nullable();
            $table->string('birth_country')->nullable();
            $table->string('nationality')->nullable();
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->text('address')->nullable();
            $table->string('blood_type', 5)->nullable();
            $table->string('photo')->nullable();
            // Section B: Parent
            $table->string('parent_full_name')->nullable();
            $table->string('marital_status')->nullable();
            $table->string('telephone')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('email')->nullable();
            $table->string('education')->nullable();
            $table->string('job')->nullable();
            // Section C: Academic
            $table->string('grade')->nullable();
            $table->string('academic_year')->nullable();
            // Section D: Medical
            $table->boolean('has_allergies')->default(false);
            $table->text('allergies_details')->nullable();
            $table->boolean('has_medical_conditions')->default(false);
            $table->text('medical_condition_details')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
