<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
{
    Schema::create('invoices', function (Blueprint $table) {
        $table->id();
        $table->foreignId('student_id')->constrained('students')->onDelete('cascade');
        $table->decimal('total_amount', 10, 2); 
        $table->decimal('paid_amount', 10, 2); 
        $table->decimal('remaining_amount', 10, 2);
        $table->unsignedTinyInteger('discount_percent')->nullable();  
        $table->decimal('discount_amount', 10, 2)->nullable(); 
        $table->decimal('tuition_after_discount', 10, 2)->nullable();
        $table->string('status')->default('pending');
        $table->timestamps();
    });
}


    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
