<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('treasuries', function (Blueprint $table) {
            $table->id();
            $table->string('currency', 10);
            $table->decimal('balance', 15, 2)->default(0);
            $table->decimal('initial_balance', 15, 2)->default(0);
            $table->timestamps();
        });

        DB::table('treasuries')->insert([
            ['currency'=>'USD','balance'=>0,'initial_balance'=>0,'created_at'=>now(),'updated_at'=>now()],
            ['currency'=>'EGP','balance'=>0,'initial_balance'=>0,'created_at'=>now(),'updated_at'=>now()],
            ['currency'=>'KSA','balance'=>0,'initial_balance'=>0,'created_at'=>now(),'updated_at'=>now()],
            ['currency'=>'SDG','balance'=>0,'initial_balance'=>0,'created_at'=>now(),'updated_at'=>now()],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('treasuries');
    }
};
