<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        /**
         * TABLE: grade_fees
         * يحتوي على اسم الصف + الرسوم + رسوم التسجيل
         * بدون أي علاقات خارجية
         */
        Schema::create('grade_fees', function (Blueprint $table) {
            $table->id();

            // اسم الصف مثل (KG1 - Grade 1 - Grade 2 - ...)
            $table->string('grade');

            // رسوم الصف بالدولار
            $table->decimal('amount_usd', 10, 2);

            // رسوم التسجيل بالدولار
            $table->decimal('registration_usd', 10, 2)->default(0);

            $table->timestamps();
        });

        /**
         * TABLE: transportation_fees
         * يحتوي على رسوم النقل حسب المنطقة
         */
        Schema::create('transportation_fees', function (Blueprint $table) {
            $table->id();

            // اسم المنطقة
            $table->string('zone'); // Zone A / B / C

            // رسوم النقل بالجنيه
            $table->decimal('fee_egp', 10, 2);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transportation_fees');
        Schema::dropIfExists('grade_fees');
    }
};
