<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
{
    Schema::create('payments', function (Blueprint $table) {
        $table->id();

        $table->foreignId('invoice_id')->constrained()->onDelete('cascade');
        $table->foreignId('installment_id')->nullable()->constrained()->onDelete('cascade');
        $table->foreignId('student_id')->constrained()->onDelete('cascade');

        // 🔹 Payment date
        $table->date('payment_date');

        $table->decimal('amount', 10, 2);
        $table->string('currency', 10);
        $table->decimal('exchange_rate', 10, 4);
        $table->decimal('amount_usd', 10, 2);

        $table->string('method')->nullable();
        $table->text('notes')->nullable();

        $table->timestamps();

        $table->index(['invoice_id', 'installment_id']);
        $table->index('currency');
        $table->index('payment_date');
    });
}



    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
