@extends('layouts.app')

@section('content')
<div class="container" dir="rtl">

    <!-- Title -->
    <h2 class="fw-bold mb-4">إدارة الرسوم</h2>

    <!-- Add New Fees -->
    <div class="mb-4">
        <a href="{{ route('fees.create') }}" class="btn btn-primary">
            + إضافة رسوم جديدة
        </a>
    </div>

    <!-- =====================  TABS  ===================== -->
    <ul class="nav nav-tabs mb-4" id="feesTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="grade-tab" data-bs-toggle="tab" data-bs-target="#gradeFees"
                    type="button" role="tab">
                الرسوم الدراسية
            </button>
        </li>

        <li class="nav-item" role="presentation">
            <button class="nav-link" id="transport-tab" data-bs-toggle="tab" data-bs-target="#transportFees"
                    type="button" role="tab">
                رسوم المواصلات
            </button>
        </li>
    </ul>

    <div class="tab-content">

        <!-- =====================  TAB 1: Grade Fees  ===================== -->
        <div class="tab-pane fade show active" id="gradeFees" role="tabpanel">

            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <strong>الرسوم الدراسية (حسب الصف)</strong>
                </div>

                <div class="card-body p-0">
                    <table class="table table-hover table-striped mb-0 text-center">
                        <thead class="table-dark">
                            <tr>
                                <th>الصف</th>
                                <th>الرسوم (USD)</th>
                                <th>رسوم التسجيل (USD)</th>
                                <th width="140">الإجراءات</th>
                            </tr>
                        </thead>

                        <tbody>
                            @forelse($grade_fees as $fee)
                                <tr>
                                    <td class="fw-semibold">{{ $fee->grade }}</td>
                                    <td>{{ number_format($fee->amount_usd, 2) }}</td>
                                    <td>{{ number_format($fee->registration_usd, 2) }}</td>

                                    <td>
                                        <a href="#" class="btn btn-sm btn-warning">تعديل</a>

                                        <form action="#" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button class="btn btn-sm btn-danger"
                                                    onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="text-muted py-4">
                                        لا توجد رسوم دراسية مسجلة.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

        <!-- =====================  TAB 2: Transportation Fees  ===================== -->
        <div class="tab-pane fade" id="transportFees" role="tabpanel">

            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <strong>رسوم المواصلات (حسب المنطقة)</strong>
                </div>

                <div class="card-body p-0">
                    <table class="table table-hover table-striped mb-0 text-center">
                        <thead class="table-dark">
                            <tr>
                                <th>المنطقة</th>
                                <th>الرسوم (EGP)</th>
                                <th width="140">الإجراءات</th>
                            </tr>
                        </thead>

                        <tbody>
                            @forelse($transport_fees as $tfee)
                                <tr>
                                    <td class="fw-semibold">{{ $tfee->zone }}</td>
                                    <td>{{ number_format($tfee->fee_egp, 2) }}</td>

                                    <td>
                                        <a href="#" class="btn btn-sm btn-warning">تعديل</a>

                                        <form action="#" method="POST" class="d-inline">
                                            @csrf @method('DELETE')
                                            <button class="btn btn-sm btn-danger"
                                                    onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                                حذف
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-muted py-4">
                                        لا توجد رسوم مواصلات مسجلة.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

    </div>

</div>
@endsection
