@extends('layouts.app')

@section('content')
<div class="container py-4" dir="rtl">
    <h4 class="fw-bold mb-4">إنشاء فاتورة جديدة</h4>

    <!-- SELECT STUDENT -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="{{ route('invoices.create') }}">
                <div class="mb-3">
                    <label class="form-label">اختر الطالب</label>
                    <select name="student_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- اختر الطالب --</option>
                        @foreach($students as $stu)
                            <option value="{{ $stu->id }}" @if(request('student_id') == $stu->id) selected @endif>
                                {{ $stu->fname }} {{ $stu->lname }} - {{ $stu->grade }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </form>
        </div>
    </div>

    @if(isset($student))

    <!-- IF INVOICE EXISTS -->
    @if($hasInvoice)
        <div class="alert alert-danger">
            هذا الطالب لديه فاتورة بالفعل ولا يمكن إنشاء فاتورة أخرى.
        </div>
        @endif

    @if(!$hasInvoice)

    <!-- STUDENT INFO -->
    <div class="card mb-4">
        <div class="card-body">
            <h5>بيانات الطالب</h5>
            <p><strong>الاسم:</strong> {{ $student->fname }} {{ $student->lname }}</p>
            <p><strong>الصف:</strong> {{ $student->grade }}</p>
        </div>
    </div>

    <!-- FEES TABLE -->
    <div class="card mb-4">
        <div class="card-body">
            <h5>الرسوم الدراسية للصف</h5>
            <table class="table table-bordered text-center">
                <thead>
                    <tr>
                        <th>البند</th>
                        <th>المبلغ بالدولار</th>
                    </tr>
                </thead>
                <tbody>
                    @php 
                        $gradeFee = $fees->first();
                        $grade_amount = $gradeFee ? $gradeFee->amount_usd : 0;
                        $registration = $registration_fee ?? 0;
                        $baseTotal = $grade_amount + $registration;
                    @endphp

                    <tr>
                        <td>رسوم التسجيل</td>
                        <td>{{ number_format($registration, 2) }} $</td>
                    </tr>

                    @if($gradeFee)
                        <tr>
                            <td>رسوم الصف</td>
                            <td>{{ number_format($grade_amount, 2) }} $</td>
                        </tr>
                    @endif
                </tbody>
            </table>

            <h5 class="mt-3">المجموع الأساسي: <strong id="baseTotal">{{ number_format($baseTotal, 2) }}</strong> $</h5>
        </div>
    </div>

    <!-- DISCOUNT + TRANSPORT -->
    <form action="{{ route('invoices.store') }}" method="POST">
        @csrf
        <input type="hidden" name="student_id" value="{{ $student->id }}">
        <input type="hidden" id="gradeFeeValue" value="{{ $grade_amount }}">
        <input type="hidden" id="registrationFeeValue" value="{{ $registration }}">
        <input type="hidden" id="finalTotalInput" name="total_after_discount" value="{{ $baseTotal }}">

        <div class="card mb-4">
            <div class="card-body">

                <!-- TRANSPORT SELECT -->
                <div class="mb-3">
                    <label class="form-label">اختر منطقة المواصلات</label>
                    <select class="form-select" name="transport_fee" id="transport_fee">
                        <option value="0">بدون مواصلات</option>
                        @foreach($transportation as $t)
                            <option value="{{ $t->fee_egp }}">{{ $t->zone }} - {{ number_format($t->fee_egp, 2) }} جنيه</option>
                        @endforeach
                    </select>
                </div>

                <!-- DISCOUNT -->
                <div class="mb-3">
                    <label class="form-label">خصم (يطبق فقط على رسوم الصف)</label>
                    <input type="number" class="form-control" name="discount" id="discount" value="0">
                </div>

                <h5 class="mt-3">
                    الإجمالي بعد الخصم:  
                    <strong id="finalTotal">{{ number_format($baseTotal, 2) }}</strong> $
                </h5>

            </div>
        </div>

        <button type="submit" class="btn btn-success w-100">إنشاء الفاتورة</button>
    </form>

    @endif <!-- if no invoice -->
    @endif <!-- if student -->
</div>

<script>
function calculateTotal() {
    let gradeFee = parseFloat(document.getElementById('gradeFeeValue').value);
    let registration = parseFloat(document.getElementById('registrationFeeValue').value);
    let discount = parseFloat(document.getElementById('discount').value) || 0;
    let transport = parseFloat(document.getElementById('transport_fee').value) || 0;

    // Discount only on grade fee
    let gradeAfterDiscount = gradeFee - discount;

    // Total
    let finalTotal = gradeAfterDiscount + registration + transport;

    document.getElementById('finalTotal').innerText = finalTotal.toFixed(2);
    document.getElementById('finalTotalInput').value = finalTotal;
}

document.getElementById('discount')?.addEventListener('input', calculateTotal);
document.getElementById('transport_fee')?.addEventListener('change', calculateTotal);
</script>
@endsection
