@extends('layouts.app')

@section('content')
<div class="container mt-4" dir="rtl">

    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">🧾 قائمة الفواتير</h4>
        <a href="{{ route('invoices.create') }}" class="btn btn-success rounded-pill px-4 shadow-sm">
            ➕ إنشاء فاتورة جديدة
        </a>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm mb-4 border-0">
        <div class="card-body">
            <form action="{{ route('invoices.index') }}" method="GET" class="row g-3">

                <!-- Search -->
                <div class="col-md-4">
                    <label class="form-label fw-bold">🔍 البحث</label>
                    <input type="text" name="search" value="{{ request('search') }}"
                           class="form-control text-end shadow-sm"
                           placeholder="ابحث برقم الفاتورة أو اسم الطالب">
                </div>

                <!-- Status -->
                <div class="col-md-3">
                    <label class="form-label fw-bold">⚙️ حالة الفاتورة</label>
                    <select name="status" class="form-select text-end shadow-sm">
                        <option value="">جميع الحالات</option>
                        <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>مدفوعة بالكامل</option>
                        <option value="partial" {{ request('status') == 'partial' ? 'selected' : '' }}>مدفوعة جزئياً</option>
                        <option value="unpaid" {{ request('status') == 'unpaid' ? 'selected' : '' }}>غير مدفوعة</option>
                    </select>
                </div>

                <!-- Date Range -->
                <div class="col-md-2">
                    <label class="form-label fw-bold">📅 من</label>
                    <input type="date" name="from_date" value="{{ request('from_date') }}" class="form-control shadow-sm">
                </div>

                <div class="col-md-2">
                    <label class="form-label fw-bold">📅 إلى</label>
                    <input type="date" name="to_date" value="{{ request('to_date') }}" class="form-control shadow-sm">
                </div>

                <div class="col-md-12 text-start mt-3">
                    <button class="btn btn-primary px-4 rounded-pill">بحث</button>
                    <a href="{{ route('invoices.index') }}" class="btn btn-secondary px-4 rounded-pill">إعادة تعيين</a>
                </div>

            </form>
        </div>
    </div>

    <!-- Invoice Table -->
    <div class="card shadow-sm border-0">
        <div class="card-header bg-dark text-white fw-bold">📋 تفاصيل الفواتير</div>

        <div class="table-responsive">
            <table class="table table-bordered table-hover text-end align-middle mb-0">
                <thead class="table-light text-center fw-bold">
                    <tr>
                        <th>#</th>
                        <th>رقم الفاتورة</th>
                        <th>اسم الطالب</th>
                        <th>العملة</th>
                        <th>المبلغ الإجمالي</th>
                        <th>المبلغ المدفوع</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>

                <tbody>
                    @forelse ($invoices as $invoice)
                    <tr>
                        <td class="text-center">{{ $loop->iteration }}</td>
                        <td>{{ $invoice->invoice_no }}</td>
                        <td>{{ $invoice->student->full_name ?? 'غير معروف' }}</td>

                        <td>
                            <span class="badge bg-secondary">
                                {{ $invoice->currency ?? 'USD' }}
                            </span>
                        </td>

                        <td>{{ number_format($invoice->total_amount, 2) }} {{ $invoice->currency }}</td>
                        <td>{{ number_format($invoice->paid_amount, 2) }} {{ $invoice->currency }}</td>

                        <td class="text-center">
                            <span class="badge fs-6 px-3 py-2
                                @if($invoice->status == 'paid') bg-success
                                @elseif($invoice->status == 'partial') bg-warning text-dark
                                @else bg-danger @endif">
                                @if($invoice->status == 'paid')
                                    ✅ مدفوعة بالكامل
                                @elseif($invoice->status == 'partial')
                                    ⚠️ مدفوعة جزئياً
                                @else
                                    ❌ غير مدفوعة
                                @endif
                            </span>
                        </td>

                        <td class="text-center">
                            <div class="d-flex justify-content-end gap-2">
                                <a href="{{ route('invoices.show', $invoice->id) }}" class="btn btn-sm btn-info rounded-pill px-3">👁️ عرض</a>
                                <a href="{{ route('invoices.payments.index', $invoice->id) }}" class="btn btn-sm btn-primary rounded-pill px-3">💳 الدفعات</a>
                                <a href="{{ route('invoices.edit', $invoice->id) }}" class="btn btn-sm btn-warning rounded-pill px-3">✏️ تعديل</a>

                                <form action="{{ route('invoices.destroy', $invoice->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button onclick="return confirm('هل أنت متأكد أنك تريد حذف هذه الفاتورة؟')"
                                            class="btn btn-sm btn-danger rounded-pill px-3">
                                        🗑️ حذف
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center text-muted py-4">لا توجد فواتير مسجلة حالياً.</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light text-center">
            {{ $invoices->links() }}
        </div>
    </div>

</div>
@endsection
