@extends('layouts.app')

@section('content')
<div class="container" dir="rtl">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">فاتورة #{{ $invoice->id }}</h4>
        <a href="{{ route('invoices.index') }}" class="btn btn-secondary">رجوع</a>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h5>معلومات الطالب</h5>
            <p><strong>الاسم:</strong> {{ $invoice->student->fname }} {{ $invoice->student->lname }}</p>
            <p><strong>الصف:</strong> {{ $invoice->student->grade }}</p>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h5>تفاصيل الفاتورة</h5>
            <table class="table table-bordered">
                <tr>
                    <th>المبلغ الإجمالي</th>
                    <td>{{ number_format($invoice->total_amount, 2) }} $</td>
                </tr>
                <tr>
                    <th>المبلغ المدفوع</th>
                    <td>{{ number_format($invoice->paid_amount, 2) }} $</td>
                </tr>
                <tr>
                    <th>المبلغ المتبقي</th>
                    <td class="{{ $invoice->remaining_amount > 0 ? 'text-danger fw-bold' : 'text-success' }}">
                        {{ number_format($invoice->remaining_amount, 2) }} $
                    </td>
                </tr>
                <tr>
                    <th>الحالة</th>
                    <td>
                        <span class="badge bg-{{ $invoice->status == 'paid' ? 'success' : ($invoice->status == 'partial' ? 'warning' : 'danger') }}">
                            {{ $invoice->status == 'paid' ? 'مدفوعة' : ($invoice->status == 'partial' ? 'جزئية' : 'pending') }}
                        </span>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Payments Section -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">الدفعات</h5>
            @if($invoice->remaining_amount > 0)
                {{-- Make sure this link uses the correct route --}}
                <a href="{{ route('invoices.payments.create', $invoice) }}" class="btn btn-success">
                    إضافة دفعة
                </a>
            @endif
        </div>
        <div class="card-body">
            @if($invoice->payments->count() > 0)
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>تاريخ الدفع</th>
                            <th>العملة</th>
                            <th>المبلغ</th>
                            <th>المبلغ بالدولار</th>
                            <th>طريقة الدفع</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoice->payments as $payment)
                        <tr>
                            <td>{{ $payment->payment_date }}</td>
                            <td>{{ $payment->currency }}</td>
                            <td>{{ number_format($payment->amount, 2) }} {{ $payment->currency }}</td>
                            <td>{{ number_format($payment->amount_usd, 2) }} $</td>
                            <td>{{ $payment->method ?? 'غير محدد' }}</td>
                            <td>
                                <form action="{{ route('payments.destroy', $payment) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm" 
                                            onclick="return confirm('هل أنت متأكد من حذف هذه الدفعة؟')">
                                        حذف
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            @else
                <p class="text-muted text-center">لا توجد دفعات مسجلة لهذه الفاتورة</p>
            @endif
        </div>
    </div>
</div>
@endsection