<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'نظام المدرسة')</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Cairo Font -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #1abc9c;
            --light-color: #ecf0f1;
            --dark-color: #2c3e50;
            --sidebar-width: 260px;
            --header-height: 70px;
            --transition-speed: 0.3s;
        }

        * { margin: 0; padding: 0; box-sizing: border-box; }

        body {
            background-color: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            direction: rtl;
        }

        /* ---------------- HEADER ---------------- */
        .header {
            height: var(--header-height);
            background: linear-gradient(135deg, var(--primary-color), var(--dark-color));
            color: white;
            position: fixed;
            top: 0; right: 0; left: 0;
            z-index: 1030;
            display: flex; align-items: center;
            padding: 0 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .logo-icon { font-size: 1.8rem; color: var(--accent-color); }
        .logo-text { font-size: 1.4rem; font-weight: 700; }

        /* ---------------- SIDEBAR ---------------- */
        .sidebar {
            width: var(--sidebar-width);
            height: calc(100vh - var(--header-height));
            position: fixed;
            top: var(--header-height);
            right: 0;
            background: linear-gradient(to bottom, var(--primary-color), var(--dark-color));
            color: white;
            padding: 20px 0;
            overflow-y: auto;
            transition: transform var(--transition-speed);
            z-index: 1020;
        }

        .sidebar::-webkit-scrollbar { width: 6px; }
        .sidebar::-webkit-scrollbar-thumb {
            background-color: rgba(255,255,255,0.3);
            border-radius: 10px;
        }

        .nav-link {
            padding: 12px 20px;
            color: rgba(255,255,255,0.85);
            display: flex; align-items: center;
            font-size: 15px;
            border-right: 3px solid transparent;
            text-decoration: none;
            transition: 0.2s ease;
        }

        .nav-link i {
            margin-left: 10px;
            font-size: 1.3rem;
            width: 26px;
            text-align: center;
        }

        .nav-link:hover {
            background-color: rgba(255,255,255,0.12);
            color: white;
            border-right-color: var(--accent-color);
        }

        .nav-link.active {
            background-color: rgba(26,188,156,0.25);
            color: white;
            border-right-color: var(--accent-color);
            position: relative;
        }

        .nav-link.active::before {
            content: '';
            position: absolute;
            right: 0; top: 0;
            height: 100%; width: 3px;
            background: var(--accent-color);
        }

        /* ---------------- Tabs Styling (Keep text dark) ---------------- */
.nav-tabs {
    border-bottom: none; /* remove default bottom border */
    margin-bottom: 1.5rem;
}

.nav-tabs .nav-link {
    color: #000 !important; /* dark text for inactive tabs */
    background-color: transparent;
    border: 1px solid transparent;
    border-radius: 8px 8px 0 0;
    transition: all 0.2s ease;
    margin-right: 5px; /* spacing between tabs */
}

.nav-tabs .nav-link:hover {
    color: #000 !important; /* dark text on hover */
}

.nav-tabs .nav-link.active {
    color: #000 !important; /* dark text when active */
    background-color: #f1f1f1; /* light background for active tab */
    border-color: #ccc #ccc transparent; /* subtle border */
    box-shadow: 0 2px 6px rgba(0,0,0,0.1); /* optional shadow */
}


        /* Mobile */
        @media (max-width: 992px) {
            .sidebar {
                transform: translateX(100%);
            }
            .sidebar.open {
                transform: translateX(0);
            }
            .sidebar-overlay.active { display: block; }
            .main-content {
                margin-right: 0 !important;
            }
        }

        /* ---------------- MAIN CONTENT ---------------- */
        .main-content {
            margin-right: var(--sidebar-width);
            padding: 30px;
            margin-top: var(--header-height);
            min-height: calc(100vh - var(--header-height));
            transition: margin-right var(--transition-speed);
        }

        /* Overlay for mobile */
        .sidebar-overlay {
            position: fixed;
            top: 0; right: 0; left: 0; bottom: 0;
            background: rgba(0,0,0,0.45);
            z-index: 1000;
            display: none;
        }

         /* Modern Action Buttons */
    .action-btn {
        width: 38px;
        height: 38px;
        border-radius: 8px;
        display: inline-flex;
        justify-content: center;
        align-items: center;
        color: #fff !important;
        border: none;
        margin: 2px;
        transition: 0.2s ease;
        font-size: 15px;
    }

    .action-btn i {
        font-size: 15px;
    }

    .action-btn:hover {
        transform: translateY(-3px);
        opacity: 0.9;
    }

    /* Colors */
    .btn-add     { background: #0d6efd; }
    .btn-view    { background: #17a2b8; }
    .btn-pdf     { background: #6c757d; }
    .btn-delete  { background: #dc3545; }
    </style>
</head>

<body>

<!-- ---------------- HEADER ---------------- -->
<!-- ---------------- HEADER ---------------- -->
<header class="header">
    <button class="btn btn-link text-white d-lg-none me-3 p-0" id="toggleSidebar">
        <i class="bi bi-list" style="font-size: 1.6rem;"></i>
    </button>

    <div class="d-flex align-items-center justify-content-between w-100">
        <!-- Logo -->
        <div class="logo d-flex align-items-center">
            <div class="logo-icon"><i class="bi bi-mortarboard-fill"></i></div>
            <div class="logo-text">نظام المدرسة</div>
        </div>

        <!-- User Info / Actions -->
        <div class="dropdown">
            <button class="btn btn-link text-white d-flex align-items-center gap-2" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                <!-- User Avatar (first letter) -->
                <div class="user-avatar rounded-circle bg-success d-flex justify-content-center align-items-center" style="width:40px; height:40px;">
                    {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                </div>
                <!-- User Name -->
                <span class="d-none d-md-inline">{{ auth()->user()->name }}</span>
                <i class="bi bi-chevron-down"></i>
            </button>
            <ul class="dropdown-menu dropdown-menu-end">
                <li>
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button type="submit" class="dropdown-item">
                            <i class="bi bi-box-arrow-right me-2"></i> تسجيل الخروج
                        </button>
                    </form>
                </li>
            </ul>
        </div>
    </div>
</header>


<!-- Overlay (Mobile) -->
<div class="sidebar-overlay" id="sidebarOverlay"></div>

<!-- ---------------- SIDEBAR ---------------- -->
<aside class="sidebar" id="sidebarMenu">
    <ul class="nav flex-column px-2">

        <li class="nav-item">
            <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                <i class="bi bi-speedometer2"></i> لوحة التحكم
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('students.index') }}" class="nav-link {{ request()->routeIs('students.*') ? 'active' : '' }}">
                <i class="bi bi-people-fill"></i> الطلاب
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('invoices.index') }}" class="nav-link {{ request()->routeIs('invoices.*') ? 'active' : '' }}">
                <i class="bi bi-receipt-cutoff"></i> الفواتير
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('payments.index') }}" class="nav-link {{ request()->routeIs('payments.*') ? 'active' : '' }}">
                <i class="bi bi-credit-card-2-front-fill"></i> المدفوعات
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('installments.index') }}" class="nav-link {{ request()->routeIs('installments.*') ? 'active' : '' }}">
                <i class="bi bi-calendar-event-fill"></i> الأقساط
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('expenses.index') }}" class="nav-link {{ request()->routeIs('expenses.*') ? 'active' : '' }}">
                <i class="bi bi-arrow-down-circle-fill"></i> المصروفات
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('treasuries.index') }}" class="nav-link {{ request()->routeIs('treasuries.*') ? 'active' : '' }}">
                <i class="bi bi-piggy-bank-fill"></i> الخزينة
            </a>
        </li>

        <li class="nav-item">
            <a href="{{ route('fees.index') }}" class="nav-link {{ request()->routeIs('fees.*') ? 'active' : '' }}">
                <i class="bi bi-cash-coin"></i> إعداد الرسوم
            </a>
        </li>

    </ul>
</aside>

<!-- ---------------- MAIN CONTENT ---------------- -->
<main class="main-content" id="mainContent">
    @yield('content')
</main>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const sidebar = document.getElementById('sidebarMenu');
        const toggleButton = document.getElementById('toggleSidebar');
        const sidebarOverlay = document.getElementById('sidebarOverlay');

        function toggleSidebar() {
            sidebar.classList.toggle('open');
            sidebarOverlay.classList.toggle('active');
            document.body.style.overflow = sidebar.classList.contains('open') ? 'hidden' : '';
        }

        toggleButton.addEventListener('click', toggleSidebar);
        sidebarOverlay.addEventListener('click', toggleSidebar);
    });
</script>

</body>
</html>
