<!-- resources/views/invoices/index.blade.php -->
@extends('layouts.app')

@section('content')
<div class="container-fluid" dir="rtl">
    <!-- عنوان الصفحة -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">الفواتير والمدفوعات</h1>
        <a href="{{ route('payments.create') }}" class="d-none d-sm-inline-block btn btn-sm btn-primary shadow-sm">
            <i class="fas fa-plus fa-sm text-white-50"></i> إنشاء فاتورة جديدة
        </a>
    </div>

    <!-- بطاقات الإحصائيات -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-right-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                إجمالي الفواتير</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total_invoices'] }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-invoice fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-right-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                إجمالي المبالغ</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($stats['total_amount'], 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-right-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                المبلغ المدفوع</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($stats['total_paid'], 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-right-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col me-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                المبلغ المتبقي</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">${{ number_format($stats['total_remaining'], 2) }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- جدول الفواتير -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">جميع الفواتير</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered text-center" id="dataTable" width="100%" cellspacing="0">
                    <thead class="table-light">
                        <tr>
                            <th>رقم الفاتورة</th>
                            <th>اسم الطالب</th>
                            <th>الصف الدراسي</th>
                            <th>المبلغ الإجمالي</th>
                            <th>المبلغ المدفوع (دولار)</th>
                            <th>تفاصيل الدفعات</th>
                            <th>المتبقي (دولار)</th>
                            <th>الحالة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoices as $invoice)
                        <tr>
                            <td>#{{ $invoice->id }}</td>
                            <td>{{ $invoice->student->fname }} {{ $invoice->student->lname }}</td>
                            <td>{{ $invoice->student->grade }}</td>
                            <td>${{ number_format($invoice->total_amount, 2) }}</td>
                            <td>${{ number_format($invoice->paid_amount, 2) }}</td>
                            <td>
                                @if($invoice->payments->count() > 0)
                                    @php
                                        $paymentBreakdown = $invoice->payments->groupBy('currency');
                                    @endphp
                                    @foreach($paymentBreakdown as $currency => $payments)
                                        <div class="payment-breakdown">
                                            <span class="font-weight-bold">{{ number_format($payments->sum('amount'), 2) }} {{ $currency }}</span>
                                            <small class="text-muted">(سعر الصرف: {{ $payments->first()->exchange_rate ?? 'غير متاح' }})</small>
                                        </div>
                                    @endforeach
                                @else
                                    <span class="text-muted">لا توجد دفعات</span>
                                @endif
                            </td>
                            <td>${{ number_format($invoice->remaining_amount, 2) }}</td>
                            <td>
                                @if($invoice->status == 'paid')
                                    <span class="badge bg-success">مدفوعة</span>
                                @elseif($invoice->status == 'partial')
                                    <span class="badge bg-warning text-dark">مدفوعة جزئياً</span>
                                @else
                                    <span class="badge bg-danger">غير مدفوعة</span>
                                @endif
                            </td>

<td class="text-nowrap">
<!-- Add Payment -->
<a href="{{ route('payments.create', ['student_id' => $invoice->student_id]) }}" 
   class="action-btn btn-add" title="إضافة دفعة">
    <i class="fas fa-plus"></i>
</a>

<!-- View Payments -->
<button class="action-btn btn-view" onclick="showPayments({{ $invoice->id }})" title="عرض الدفعات">
    <i class="fas fa-eye"></i>
</button>

<!-- Print PDF -->
<a href="#"
   class="action-btn btn-pdf" target="_blank" title="طباعة PDF">
    <i class="fas fa-file-pdf"></i>
</a>

<!-- Delete -->
<form action="{{ route('payments.destroy', $invoice->id) }}" method="POST" class="d-inline"
      onsubmit="return confirm('هل تريد حذف هذه الفاتورة؟')">
    @csrf
    @method('DELETE')
    <button type="submit" class="action-btn btn-delete" title="حذف">
        <i class="fas fa-trash-alt"></i>
    </button>
</form>


</td>


                            
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- نافذة عرض الدفعات -->
<div class="modal fade" id="paymentsModal" tabindex="-1" role="dialog" aria-labelledby="paymentsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="paymentsModalLabel">تفاصيل الدفعات - الفاتورة رقم <span id="invoiceNumber"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="إغلاق">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="paymentsModalBody">
                <div class="text-center">
                    <div class="spinner-border text-primary" role="status">
                        <span class="sr-only">جارِ التحميل...</span>
                    </div>
                    <p>جارِ تحميل تفاصيل الدفعات...</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .badge { font-size: 0.8em; }
    .payment-breakdown {
        padding: 2px 0;
        border-bottom: 1px solid #f8f9fa;
    }
    .payment-breakdown:last-child { border-bottom: none; }
    .payment-detail {
        background: #f8f9fa;
        border-radius: 5px;
        padding: 10px;
        margin: 5px 0;
    }
</style>
@endpush

@push('scripts')
<script>
function showPayments(invoiceId) {
    $('#paymentsModalBody').html(`
        <div class="text-center">
            <div class="spinner-border text-primary" role="status"></div>
            <p>جارِ تحميل تفاصيل الدفعات...</p>
        </div>
    `);
    $('#invoiceNumber').text(invoiceId);
    $('#paymentsModal').modal('show');

    fetch(`/payments/student-fees/${invoiceId}`)
        .then(res => res.json())
        .then(data => {
            if(data.success) displayPaymentDetails(data);
            else $('#paymentsModalBody').html(`<div class="alert alert-danger">${data.message}</div>`);
        })
        .catch(() => {
            $('#paymentsModalBody').html(`<div class="alert alert-danger">حدث خطأ في الاتصال.</div>`);
        });
}

function displayPaymentDetails(data) {
    const invoice = data.invoice;
    const student = data.student;
    const breakdown = data.payment_breakdown;

    let html = `
        <div class="row mb-4">
            <div class="col-md-6">
                <h6>بيانات الطالب</h6>
                <p><strong>الاسم:</strong> ${student.fname} ${student.lname}</p>
                <p><strong>الصف:</strong> ${student.grade}</p>
                <p><strong>الهاتف:</strong> ${student.phone}</p>
            </div>
            <div class="col-md-6">
                <h6>ملخص الفاتورة</h6>
                <p><strong>الإجمالي:</strong> $${invoice.total_amount.toFixed(2)}</p>
                <p><strong>المدفوع:</strong> $${invoice.paid_amount.toFixed(2)}</p>
                <p><strong>المتبقي:</strong> $${invoice.remaining_amount.toFixed(2)}</p>
            </div>
        </div><hr>`;

    if(Object.keys(breakdown).length > 0){
        html += `<h6>تفاصيل الدفعات حسب العملة</h6><div class="row mb-3">`;
        for(const [currency, item] of Object.entries(breakdown)){
            html += `
                <div class="col-md-3 mb-2">
                    <div class="payment-detail">
                        <h6>${currency}</h6>
                        <p><strong>الإجمالي:</strong> ${parseFloat(item.total_amount).toFixed(2)} ${currency}</p>
                        <p><strong>بالدولار:</strong> $${parseFloat(item.total_usd).toFixed(2)}</p>
                    </div>
                </div>`;
        }
        html += `</div><h6>سجل الدفعات</h6>
            <div class="table-responsive">
                <table class="table table-bordered table-sm text-center">
                    <thead><tr><th>التاريخ</th><th>المبلغ</th><th>العملة</th><th>سعر الصرف</th><th>بالدولار</th></tr></thead>
                    <tbody>`;

        for(const [currency, item] of Object.entries(breakdown)){
            item.payments.forEach(p => {
                html += `<tr>
                    <td>${new Date(p.created_at).toLocaleDateString()}</td>
                    <td>${parseFloat(p.amount).toFixed(2)}</td>
                    <td>${p.currency}</td>
                    <td>${parseFloat(p.exchange_rate).toFixed(4)}</td>
                    <td>$${parseFloat(p.amount_usd).toFixed(2)}</td>
                </tr>`;
            });
        }
        html += `</tbody></table></div>`;
    } else {
        html += `<div class="alert alert-info text-center">لا توجد دفعات مسجلة.</div>`;
    }

    const paidPercentage = (invoice.paid_amount / invoice.total_amount) * 100;
    html += `
        <hr><h6>نسبة التقدم في السداد</h6>
        <div class="progress mb-2" style="height: 20px;">
            <div class="progress-bar ${paidPercentage===100?'bg-success':paidPercentage>0?'bg-warning':'bg-danger'}"
                 role="progressbar" style="width:${paidPercentage}%;">
                ${paidPercentage.toFixed(1)}%
            </div>
        </div>
        <div class="row text-center">
            <div class="col-md-4"><small>الإجمالي: $${invoice.total_amount.toFixed(2)}</small></div>
            <div class="col-md-4"><small>المدفوع: $${invoice.paid_amount.toFixed(2)}</small></div>
            <div class="col-md-4"><small>المتبقي: $${invoice.remaining_amount.toFixed(2)}</small></div>
        </div>`;

    $('#paymentsModalBody').html(html);
}
</script>
@endpush

