@extends('layouts.app')

@section('content')
<div class="container" dir="rtl">
    <h2 class="fw-bold text-primary mb-4 text-center">✏️ تعديل بيانات الطالب</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('students.update', $student->id) }}" method="POST">
        @csrf
        @method('PUT')

        <!-- 🔹 Section A: البيانات الشخصية -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-primary text-white fw-bold">البيانات الشخصية</div>
            <div class="card-body">
                <div class="row g-3 mb-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">الاسم الأول</label>
                        <input type="text" name="fname" class="form-control" value="{{ old('fname', $student->fname) }}" required>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">الاسم الأوسط</label>
                        <input type="text" name="middle_name" class="form-control" value="{{ old('middle_name', $student->middle_name) }}">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">الاسم الأخير</label>
                        <input type="text" name="lname" class="form-control" value="{{ old('lname', $student->lname) }}" required>
                    </div>
                </div>

                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">تاريخ الميلاد</label>
                        <input type="date" name="date_of_birth" class="form-control" value="{{ old('date_of_birth', $student->date_of_birth) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">مكان الميلاد</label>
                        <input type="text" name="birth_city" class="form-control" value="{{ old('birth_city', $student->birth_city) }}">
                    </div>
                </div>

                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">الجنسية</label>
                        <input type="text" name="nationality" class="form-control" value="{{ old('nationality', $student->nationality) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">الجنس</label>
                        <select name="gender" class="form-select">
                            <option value="">اختر</option>
                            <option value="male" {{ old('gender', $student->gender) == 'male' ? 'selected' : '' }}>ذكر</option>
                            <option value="female" {{ old('gender', $student->gender) == 'female' ? 'selected' : '' }}>أنثى</option>
                        </select>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">العنوان</label>
                    <textarea name="address" class="form-control" rows="2" required>{{ old('address', $student->address) }}</textarea>
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">فصيلة الدم</label>
                        <input type="text" name="blood_type" class="form-control" value="{{ old('blood_type', $student->blood_type) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">رقم الهاتف</label>
                        <input type="text" name="telephone" class="form-control" value="{{ old('telephone', $student->telephone) }}" required>
                    </div>
                </div>
            </div>
        </div>

        <!-- 👨‍👩‍👧 Section B: معلومات ولي الأمر -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-success text-white fw-bold">معلومات ولي الأمر</div>
            <div class="card-body">
                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">الاسم الكامل لولي الأمر</label>
                        <input type="text" name="parent_full_name" class="form-control" value="{{ old('parent_full_name', $student->parent_full_name) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">الحالة الاجتماعية</label>
                        <input type="text" name="marital_status" class="form-control" value="{{ old('marital_status', $student->marital_status) }}">
                    </div>
                </div>

                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">رقم الهاتف</label>
                        <input type="text" name="parent_telephone" class="form-control" value="{{ old('parent_telephone', $student->parent_telephone) }}">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">رقم واتساب</label>
                        <input type="text" name="whatsapp" class="form-control" value="{{ old('whatsapp', $student->whatsapp) }}">
                    </div>
                </div>

                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">البريد الإلكتروني</label>
                        <input type="email" name="email" class="form-control" value="{{ old('email', $student->email) }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">المؤهل العلمي</label>
                        <input type="text" name="education" class="form-control" value="{{ old('education', $student->education) }}">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label fw-bold">الوظيفة</label>
                        <input type="text" name="job" class="form-control" value="{{ old('job', $student->job) }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- 🎓 Section C: المعلومات الأكاديمية -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-info text-white fw-bold">المعلومات الأكاديمية</div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">الصف الدراسي</label>
                        <select name="grade" class="form-select" required>
                            <option value="">اختر الصف الدراسي</option>
                            @foreach($grades as $grade)
                                <option value="{{ $grade }}" {{ old('grade', $student->grade) == $grade ? 'selected' : '' }}>{{ $grade }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">السنة الأكاديمية</label>
                        <input type="text" name="academic_year" class="form-control" value="{{ old('academic_year', $student->academic_year) }}">
                    </div>
                </div>
            </div>
        </div>

        <!-- 🏥 Section D: المعلومات الطبية -->
        <div class="card shadow-sm mb-4">
            <div class="card-header bg-danger text-white fw-bold">المعلومات الطبية</div>
            <div class="card-body">
                <div class="mb-3">
                    <label class="form-label fw-bold">هل لدى الطالب أي نوع من الحساسية؟</label>
                    <select name="has_allergies" class="form-select">
                        <option value="0" {{ old('has_allergies', $student->has_allergies) == 0 ? 'selected' : '' }}>لا</option>
                        <option value="1" {{ old('has_allergies', $student->has_allergies) == 1 ? 'selected' : '' }}>نعم</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">تفاصيل الحساسية</label>
                    <textarea name="allergies_details" class="form-control" rows="2">{{ old('allergies_details', $student->allergies_details) }}</textarea>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">هل يعاني الطالب من أمراض مزمنة؟</label>
                    <select name="has_medical_conditions" class="form-select">
                        <option value="0" {{ old('has_medical_conditions', $student->has_medical_conditions) == 0 ? 'selected' : '' }}>لا</option>
                        <option value="1" {{ old('has_medical_conditions', $student->has_medical_conditions) == 1 ? 'selected' : '' }}>نعم</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">تفاصيل الأمراض أو الأدوية</label>
                    <textarea name="medical_condition_details" class="form-control" rows="2">{{ old('medical_condition_details', $student->medical_condition_details) }}</textarea>
                </div>
            </div>
        </div>

        <!-- 🔘 Submit Button -->
        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success px-4">
                <i class="fas fa-save me-1"></i> تحديث الطالب
            </button>
            <a href="{{ route('students.index') }}" class="btn btn-secondary ms-2">
                <i class="fas fa-arrow-left me-1"></i> رجوع
            </a>
        </div>
    </form>
</div>
@endsection
