@extends('layouts.app')

@section('content')
<div class="container-fluid mt-4" dir="rtl">

    <!-- 🔹 Page Header -->
    <div class="d-flex flex-wrap justify-content-between align-items-center mb-4 gap-2">
        <h4 class="fw-bold mb-0">📚 قائمة الطلاب</h4>
        <a href="{{ route('students.create') }}" class="btn btn-success btn-lg shadow-sm">
            ➕ إضافة طالب
        </a>
    </div>

    <!-- 🔍 Filter and Search Section -->
    <div class="card shadow-sm mb-4 border-0">
        <div class="card-body">
            <form action="{{ route('students.index') }}" method="GET" class="row g-3 align-items-end">

                <!-- Filter by Grade -->
                <div class="col-12 col-md-4">
                    <label class="form-label fw-bold">📘 تصفية حسب الصف</label>
                    <select name="class_name" class="form-select text-end shadow-sm">
                        <option value="">جميع الصفوف</option>
                        @for($i = 1; $i <= 9; $i++)
                            <option value="Grade {{ $i }}" {{ request('class_name') == 'Grade '.$i ? 'selected' : '' }}>
                                Grade {{ $i }}
                            </option>
                        @endfor
                        <option value="IGCSE" {{ request('class_name') == 'IGCSE' ? 'selected' : '' }}>IGCSE</option>
                    </select>
                </div>

                <!-- Search by Name or Admission No -->
                <div class="col-12 col-md-5">
                    <label class="form-label fw-bold">🔍 البحث عن طالب</label>
                    <input type="text" name="search" value="{{ request('search') }}"
                           class="form-control text-end shadow-sm"
                           placeholder="اكتب الاسم أو رقم القيد للبحث...">
                </div>

                <!-- Buttons -->
                <div class="col-12 col-md-3 text-start mt-md-0 mt-3">
                    <button type="submit" class="btn btn-primary btn-lg w-100 mb-2">بحث</button>
                    <a href="{{ route('students.index') }}" class="btn btn-secondary btn-lg w-100">إعادة تعيين</a>
                </div>
            </form>
        </div>
    </div>

    <!-- 🧾 Students Table -->
    <div class="card shadow-sm border-0">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-bordered table-striped text-end align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>الاسم الكامل</th>
                            <th>الصف</th>
                            <th>رقم التواصل</th>
                            <th class="text-center">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($students as $student)
                        <tr>
                            <td>{{ $student->serial_number }}</td>
                            <td>{{ $student->fname }} {{ $student->middle_name }} {{ $student->lname }}</td>
                            <td>{{ $student->grade ?? '-' }}</td>
                            <td>{{ $student->telephone ?? '-' }}</td>
                            <td class="text-center">
                                <a href="{{ route('students.edit', $student) }}" class="btn btn-sm btn-warning mb-1">
                                    ✏️ تعديل
                                </a>
                                <form action="{{ route('students.destroy', $student) }}" method="POST" class="d-inline">
                                    @csrf @method('DELETE')
                                    <button class="btn btn-sm btn-danger" onclick="return confirm('هل تريد حذف هذا الطالب؟')">
                                        🗑️ حذف
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="6" class="text-center text-muted py-4">
                                لا يوجد طلاب حالياً.
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Pagination -->
        <div class="card-footer bg-light">
            {{ $students->withQueryString()->links() }}
        </div>
    </div>
</div>

<!-- Small screen optimization -->
<style>
@media (max-width: 768px) {
    .card-header small { display: block; margin-top: 5px; }
    .table thead { font-size: 0.9rem; }
    .table td, .table th { white-space: nowrap; }
    .btn { font-size: 0.9rem; }
}
</style>
@endsection
