<?php

use App\Http\Controllers\{
    DashboardController,
    ProfileController,
    StudentController,
    InvoiceController,
    PaymentController,
    InstallmentController,
    ExpenseController,
    TreasuryController,
    FeeController
};
use Illuminate\Support\Facades\Route;

// Redirect root to login page
Route::get('/', function () {
    return redirect()->route('login');
});


// Authenticated routes
Route::middleware(['auth'])->group(function() {

    Route::get('/dashboard', [DashboardController::class,'index'])->name('dashboard');
    Route::get('/login', [AuthenticatedSessionController::class, 'create'])->name('login');


    // =================== ADMIN ROUTES ===================
    Route::middleware(['role:admin'])->group(function() {

        // Core resources
        Route::resource('students', StudentController::class);
        Route::resource('installments', InstallmentController::class);
        Route::resource('payments', PaymentController::class);
        Route::resource('expenses', ExpenseController::class);
        Route::resource('treasuries', TreasuryController::class);
        Route::resource('fees', FeeController::class);

        // ========== INVOICES ==========
        Route::resource('invoices', InvoiceController::class);
        // Invoice-specific payments & installments
Route::prefix('invoices/{invoice}')->group(function () {
    Route::get('/payments', [PaymentController::class, 'index'])->name('invoices.payments.index');
    Route::get('/payments/create', [PaymentController::class, 'create'])->name('invoices.payments.create');
    Route::post('/payments', [PaymentController::class, 'store'])->name('invoices.payments.store');
    Route::get('/payments/{payment}/receipt', [PaymentController::class, 'receipt'])->name('invoices.payments.receipt');

    Route::get('/installments/create', [InstallmentController::class, 'create'])->name('installments.create');
    Route::post('/installments', [InstallmentController::class, 'store'])->name('installments.store');
});

 /*
    |--------------------------------------------------------------------------
    | Payments
    |--------------------------------------------------------------------------
    */


Route::get('/payments/create', [PaymentController::class, 'create'])->name('payments.create');
Route::get('/payments', [PaymentController::class, 'index'])->name('payments.index');
Route::post('/payments', [PaymentController::class, 'store'])->name('payments.store');
Route::get('/payments/get-student-fees/{student}', [PaymentController::class, 'getStudentFees'])->name('payments.get-student-fees');
Route::get('/payments/{payment}', [PaymentController::class, 'show'])->name('payments.show');


        // AJAX endpoints
        Route::get('/students/{id}/payment-info', [PaymentController::class, 'paymentInfo'])
            ->name('students.payment-info');
        Route::get('/students/{id}/invoices', [PaymentController::class, 'getInvoices'])
            ->name('students.invoices');
        Route::get('/students/{id}/student-data', [PaymentController::class, 'studentData'])
            ->name('students.studentData');
    });

    // =================== STAFF ROUTES ===================
    Route::middleware(['role:staff'])->group(function() {
        Route::resource('students', StudentController::class)->only(['index','show','create','store']);
        Route::resource('invoices', InvoiceController::class)->only(['index','show']);
        
        // Allow staff to create payments
        Route::get('/invoices/{invoice}/payments/create', 
            [PaymentController::class, 'create'])
            ->name('invoices.payments.create');
        Route::post('/invoices/{invoice}/payments', 
            [PaymentController::class, 'store'])
            ->name('invoices.payments.store');
    });

    // =================== PROFILE ===================
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


require __DIR__.'/auth.php';