

<?php $__env->startSection('content'); ?>
<div class="container" dir="rtl">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold">فاتورة #<?php echo e($invoice->id); ?></h4>
        <a href="<?php echo e(route('invoices.index')); ?>" class="btn btn-secondary">رجوع</a>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h5>معلومات الطالب</h5>
            <p><strong>الاسم:</strong> <?php echo e($invoice->student->fname); ?> <?php echo e($invoice->student->lname); ?></p>
            <p><strong>الصف:</strong> <?php echo e($invoice->student->grade); ?></p>
        </div>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h5>تفاصيل الفاتورة</h5>
            <table class="table table-bordered">
                <tr>
                    <th>المبلغ الإجمالي</th>
                    <td><?php echo e(number_format($invoice->total_amount, 2)); ?> $</td>
                </tr>
                <tr>
                    <th>المبلغ المدفوع</th>
                    <td><?php echo e(number_format($invoice->paid_amount, 2)); ?> $</td>
                </tr>
                <tr>
                    <th>المبلغ المتبقي</th>
                    <td class="<?php echo e($invoice->remaining_amount > 0 ? 'text-danger fw-bold' : 'text-success'); ?>">
                        <?php echo e(number_format($invoice->remaining_amount, 2)); ?> $
                    </td>
                </tr>
                <tr>
                    <th>الحالة</th>
                    <td>
                        <span class="badge bg-<?php echo e($invoice->status == 'paid' ? 'success' : ($invoice->status == 'partial' ? 'warning' : 'danger')); ?>">
                            <?php echo e($invoice->status == 'paid' ? 'مدفوعة' : ($invoice->status == 'partial' ? 'جزئية' : 'pending')); ?>

                        </span>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    <!-- Payments Section -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">الدفعات</h5>
            <?php if($invoice->remaining_amount > 0): ?>
                
                <a href="<?php echo e(route('invoices.payments.create', $invoice)); ?>" class="btn btn-success">
                    إضافة دفعة
                </a>
            <?php endif; ?>
        </div>
        <div class="card-body">
            <?php if($invoice->payments->count() > 0): ?>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>تاريخ الدفع</th>
                            <th>العملة</th>
                            <th>المبلغ</th>
                            <th>المبلغ بالدولار</th>
                            <th>طريقة الدفع</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $invoice->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($payment->payment_date); ?></td>
                            <td><?php echo e($payment->currency); ?></td>
                            <td><?php echo e(number_format($payment->amount, 2)); ?> <?php echo e($payment->currency); ?></td>
                            <td><?php echo e(number_format($payment->amount_usd, 2)); ?> $</td>
                            <td><?php echo e($payment->method ?? 'غير محدد'); ?></td>
                            <td>
                                <form action="<?php echo e(route('payments.destroy', $payment)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm" 
                                            onclick="return confirm('هل أنت متأكد من حذف هذه الدفعة؟')">
                                        حذف
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-muted text-center">لا توجد دفعات مسجلة لهذه الفاتورة</p>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH X:\Laravel Projects\PS-App\resources\views/invoices/show.blade.php ENDPATH**/ ?>