

<?php $__env->startSection('content'); ?>
<div class="container py-4" dir="rtl">
    <h4 class="fw-bold mb-4">إنشاء فاتورة جديدة</h4>

    <!-- SELECT STUDENT -->
    <div class="card mb-4">
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('invoices.create')); ?>">
                <div class="mb-3">
                    <label class="form-label">اختر الطالب</label>
                    <select name="student_id" class="form-select" onchange="this.form.submit()">
                        <option value="">-- اختر الطالب --</option>
                        <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($stu->id); ?>" <?php if(request('student_id') == $stu->id): ?> selected <?php endif; ?>>
                                <?php echo e($stu->fname); ?> <?php echo e($stu->lname); ?> - <?php echo e($stu->grade); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </form>
        </div>
    </div>

    <?php if(isset($student)): ?>

    <!-- IF INVOICE EXISTS -->
    <?php if($hasInvoice): ?>
        <div class="alert alert-danger">
            هذا الطالب لديه فاتورة بالفعل ولا يمكن إنشاء فاتورة أخرى.
        </div>
        <?php endif; ?>

    <?php if(!$hasInvoice): ?>

    <!-- STUDENT INFO -->
    <div class="card mb-4">
        <div class="card-body">
            <h5>بيانات الطالب</h5>
            <p><strong>الاسم:</strong> <?php echo e($student->fname); ?> <?php echo e($student->lname); ?></p>
            <p><strong>الصف:</strong> <?php echo e($student->grade); ?></p>
        </div>
    </div>

    <!-- FEES TABLE -->
    <div class="card mb-4">
        <div class="card-body">
            <h5>الرسوم الدراسية للصف</h5>
            <table class="table table-bordered text-center">
                <thead>
                    <tr>
                        <th>البند</th>
                        <th>المبلغ بالدولار</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        $gradeFee = $fees->first();
                        $grade_amount = $gradeFee ? $gradeFee->amount_usd : 0;
                        $registration = $registration_fee ?? 0;
                        $baseTotal = $grade_amount + $registration;
                    ?>

                    <tr>
                        <td>رسوم التسجيل</td>
                        <td><?php echo e(number_format($registration, 2)); ?> $</td>
                    </tr>

                    <?php if($gradeFee): ?>
                        <tr>
                            <td>رسوم الصف</td>
                            <td><?php echo e(number_format($grade_amount, 2)); ?> $</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>

            <h5 class="mt-3">المجموع الأساسي: <strong id="baseTotal"><?php echo e(number_format($baseTotal, 2)); ?></strong> $</h5>
        </div>
    </div>

    <!-- DISCOUNT + TRANSPORT -->
    <form action="<?php echo e(route('invoices.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="student_id" value="<?php echo e($student->id); ?>">
        <input type="hidden" id="gradeFeeValue" value="<?php echo e($grade_amount); ?>">
        <input type="hidden" id="registrationFeeValue" value="<?php echo e($registration); ?>">
        <input type="hidden" id="finalTotalInput" name="total_after_discount" value="<?php echo e($baseTotal); ?>">

        <div class="card mb-4">
            <div class="card-body">

                <!-- TRANSPORT SELECT -->
                <div class="mb-3">
                    <label class="form-label">اختر منطقة المواصلات</label>
                    <select class="form-select" name="transport_fee" id="transport_fee">
                        <option value="0">بدون مواصلات</option>
                        <?php $__currentLoopData = $transportation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($t->fee_egp); ?>"><?php echo e($t->zone); ?> - <?php echo e(number_format($t->fee_egp, 2)); ?> جنيه</option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- DISCOUNT -->
                <div class="mb-3">
                    <label class="form-label">خصم (يطبق فقط على رسوم الصف)</label>
                    <input type="number" class="form-control" name="discount" id="discount" value="0">
                </div>

                <h5 class="mt-3">
                    الإجمالي بعد الخصم:  
                    <strong id="finalTotal"><?php echo e(number_format($baseTotal, 2)); ?></strong> $
                </h5>

            </div>
        </div>

        <button type="submit" class="btn btn-success w-100">إنشاء الفاتورة</button>
    </form>

    <?php endif; ?> <!-- if no invoice -->
    <?php endif; ?> <!-- if student -->
</div>

<script>
function calculateTotal() {
    let gradeFee = parseFloat(document.getElementById('gradeFeeValue').value);
    let registration = parseFloat(document.getElementById('registrationFeeValue').value);
    let discount = parseFloat(document.getElementById('discount').value) || 0;
    let transport = parseFloat(document.getElementById('transport_fee').value) || 0;

    // Discount only on grade fee
    let gradeAfterDiscount = gradeFee - discount;

    // Total
    let finalTotal = gradeAfterDiscount + registration + transport;

    document.getElementById('finalTotal').innerText = finalTotal.toFixed(2);
    document.getElementById('finalTotalInput').value = finalTotal;
}

document.getElementById('discount')?.addEventListener('input', calculateTotal);
document.getElementById('transport_fee')?.addEventListener('change', calculateTotal);
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH X:\Laravel Projects\PS-App\resources\views/invoices/create.blade.php ENDPATH**/ ?>