

<?php $__env->startSection('content'); ?>
<div class="container py-4" dir="rtl">

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <h4 class="fw-bold mb-4">
        <i class="fas fa-money-bill-wave me-2 text-primary"></i> إدارة الرسوم
    </h4>

    <!-- TABS -->
<ul class="nav nav-tabs mb-4" id="feesTab" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="grade-tab" data-bs-toggle="tab" data-bs-target="#gradeFees" 
                type="button" role="tab">
            الرسوم الدراسية
        </button>
    </li>

    <li class="nav-item" role="presentation">
        <button class="nav-link" id="transport-tab" data-bs-toggle="tab" data-bs-target="#transportFees" 
                type="button" role="tab">
            رسوم المواصلات
        </button>
    </li>
</ul>


    <div class="tab-content" id="feesTabContent">

        <!-- Grade Fees TAB -->
        <div class="tab-pane fade show active" id="gradeFees" role="tabpanel">
            <div class="card shadow-sm mb-4">
                <div class="card-header fw-bold">الرسوم الدراسية للصفوف</div>
                <div class="card-body">

                    <form action="<?php echo e(route('fees.store.grade')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                            <div class="mb-3">
                                <label class="form-label">اختر الصف</label>
                                <select name="grade" class="form-control" required>
                                    <option value="">-- اختر الصف --</option>
                                    <?php $__currentLoopData = $grades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($grade); ?>"><?php echo e($grade); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                        <div class="mb-3">
                            <label class="form-label">المبلغ بالدولار (USD)</label>
                            <input type="number" step="0.01" name="amount_usd" class="form-control" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">رسوم التسجيل (USD)</label>
                            <input type="number" step="0.01" name="registration_usd" class="form-control" required>
                        </div>

                        <button class="btn btn-primary w-100">حفظ الرسوم الدراسية</button>
                    </form>

                </div>
            </div>
        </div>

        <!-- Transportation Fees TAB -->
        <div class="tab-pane fade" id="transportFees" role="tabpanel">
            <div class="card shadow-sm mb-4">
                <div class="card-header fw-bold">رسوم المواصلات</div>
                <div class="card-body">

                    <form action="<?php echo e(route('fees.store.transport')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="mb-3">
                            <label class="form-label">اختر المنطقة</label>
                            <select name="zone" class="form-control" required>
                                <option value="">-- اختر --</option>
                                <?php $__currentLoopData = $zones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($zone); ?>"><?php echo e($zone); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">الرسوم بالجنيه (EGP)</label>
                            <input type="number" step="0.01" name="fee_egp" class="form-control" required>
                        </div>

                        <button class="btn btn-success w-100">حفظ رسوم المواصلات</button>
                    </form>

                </div>
            </div>
        </div>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH X:\Laravel Projects\PS-App\resources\views/fees/create.blade.php ENDPATH**/ ?>